<?php

/*
 * This class should be used to include ajax actions.
 */

class dalt_Ajax
{

    protected static $instance = null;
    private $shared = null;

    private function __construct()
    {

        //Assign an instance of the plugin info
        $this->shared = dalt_Shared::get_instance();

        //Ajax requests for logged-in users ----------------------------------------------------------------------------
        add_action('wp_ajax_dalt_save_data', array($this, 'save_data'));
        add_action('wp_ajax_dalt_retrieve_table_data', array($this, 'retrieve_table_data'));
        add_action('wp_ajax_dalt_add_remove_rows', array($this, 'add_remove_rows'));
        add_action('wp_ajax_dalt_add_remove_columns', array($this, 'add_remove_columns'));
        add_action('wp_ajax_dalt_retrieve_cell_properties', array($this, 'retrieve_cell_properties'));
	    add_action('wp_ajax_dalt_retrieve_cell_properties_multiple', array($this, 'retrieve_cell_properties_multiple'));
	    add_action('wp_ajax_dalt_update_cell_properties_multiple', array($this, 'update_cell_properties_multiple'));
        add_action('wp_ajax_dalt_update_reset_cell_properties', array($this, 'update_reset_cell_properties'));
        add_action('wp_ajax_dalt_get_modal_window_content', array( $this, 'get_modal_window_content'));
	    add_action('wp_ajax_dalt_get_table_list', array( $this, 'get_table_list' ));
	    add_action('wp_ajax_dalt_insert_row_above', array($this, 'insert_row_above'));
	    add_action('wp_ajax_dalt_insert_row_below', array($this, 'insert_row_below'));
	    add_action('wp_ajax_dalt_insert_column_left', array($this, 'insert_column_left'));
	    add_action('wp_ajax_dalt_insert_column_right', array($this, 'insert_column_right'));
	    add_action('wp_ajax_dalt_remove_row', array($this, 'remove_row'));
	    add_action('wp_ajax_dalt_remove_column', array($this, 'remove_column'));
	    add_action('wp_ajax_dalt_reset_cell_properties', array($this, 'reset_cell_properties'));
	    add_action('wp_ajax_dalt_get_cell_properties_index', array($this, 'get_cell_properties_index'));

    }

    /*
     * Return an instance of this class
     */
    public static function get_instance()
    {

        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;

    }

    /**
     * This method is used to retrieve the content of the modal window generated when the TinyMCE "League Table" button
     * is clicked.
     */
    function get_modal_window_content() {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
	    $this->shared->set_max_execution_time();
	    $this->shared->set_memory_limit();

        $output = '<div id="dalt-leaguetable-body-container">';
        $output .= '<h3>' . esc_html__('Select the Table', 'dalt') . '</h3>';
        $output .= '<select id="table-id" data-placeholder="' . esc_attr__('Choose a Table', 'dalt') . '">';

        global $wpdb;
        $table_name = $wpdb->prefix . "dalt_table";
        $sql = "SELECT id, name FROM $table_name WHERE temporary = 0 ORDER BY id DESC";
        $table_a = $wpdb->get_results($sql, ARRAY_A);
        foreach ($table_a as $key => $table) {
            $output .= '<option value="' . intval($table['id'], 10) .'">' . esc_attr(stripslashes($table['name'])) . '</option>';
        }

        $output .= '</select>';
        $output .= '</div>';

	    //Generate the response and terminate the script
        echo $output;
        die();

    }

	/**
	 * A JSON string that includes name and ID of all the tables is returned.
	 */
	function get_table_list() {

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		global $wpdb;
		$table_name = $wpdb->prefix . "dalt_table";
		$sql = "SELECT id, name FROM $table_name WHERE temporary = 0 ORDER BY id DESC";
		$table_a = $wpdb->get_results($sql, ARRAY_A);

		//Generate the response and terminate the script
		echo json_encode($table_a);
		die();

	}

    /*
     * Ajax handler used to save the data of the table
     *
     * This method is called when in the "Tables" menu:
     *
     * - The "Add Table" button is clicked
     * - The "Update Table" button is clicked
     */
    public function save_data()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
        $this->shared->set_max_execution_time();
        $this->shared->set_memory_limit();

	    //Sanitization -------------------------------------------------------------------------------------------------

	    //Table data sanitized with a custom function
	    $table_data = $this->shared->sanitize_table_data($_POST['table_data']);

	    //General
	    $table_id = intval($_POST['table_id'], 10);
	    $name = sanitize_text_field($_POST['name']);
	    $description = sanitize_text_field($_POST['description']);
	    $rows = intval($_POST['rows'], 10);
	    $columns = intval($_POST['columns'], 10);

	    //Sorting
	    $enable_sorting = intval($_POST['enable_sorting'], 10);
	    $enable_manual_sorting = intval($_POST['enable_manual_sorting'], 10);
	    $show_position = intval($_POST['show_position'], 10);
	    $position_side = sanitize_key($_POST['position_side'], 10);
	    $position_label = sanitize_text_field($_POST['position_label']);
	    $number_format = intval($_POST['number_format'], 10);
	    $order_desc_asc_1 = intval($_POST['order_desc_asc_1'], 10);
	    $order_by_1 = intval($_POST['order_by_1'], 10);
	    $order_data_type_1 = sanitize_key($_POST['order_data_type_1']);
	    $order_date_format_1 = sanitize_key($_POST['order_date_format_1']);
	    $order_desc_asc_2 = intval($_POST['order_desc_asc_2'], 10);
	    $order_by_2 = intval($_POST['order_by_2'], 10);
	    $order_data_type_2 = sanitize_key($_POST['order_data_type_2']);
	    $order_date_format_2 = sanitize_key($_POST['order_date_format_2']);
	    $order_desc_asc_3 = intval($_POST['order_desc_asc_3'], 10);
	    $order_by_3 = intval($_POST['order_by_3'], 10);
	    $order_data_type_3 = sanitize_key($_POST['order_data_type_3']);
	    $order_date_format_3 = sanitize_key($_POST['order_date_format_3']);
	    $order_desc_asc_4 = intval($_POST['order_desc_asc_4'], 10);
	    $order_by_4 = intval($_POST['order_by_4'], 10);
	    $order_data_type_4 = sanitize_key($_POST['order_data_type_4']);
	    $order_date_format_4 = sanitize_key($_POST['order_date_format_4']);
	    $order_desc_asc_5 = intval($_POST['order_desc_asc_5'], 10);
	    $order_by_5 = intval($_POST['order_by_5'], 10);
	    $order_data_type_5 = sanitize_key($_POST['order_data_type_5']);
	    $order_date_format_5 = sanitize_key($_POST['order_date_format_5']);

	    //Style
	    $table_layout = intval($_POST['table_layout'], 10);
	    $table_width = intval($_POST['table_width'], 10);
	    $table_width_value = intval($_POST['table_width_value'], 10);
	    $table_minimum_width = intval($_POST['table_minimum_width'], 10);
	    $column_width = intval($_POST['column_width'], 10);
	    $column_width_value = sanitize_text_field($_POST['column_width_value']);
	    $enable_container = intval($_POST['enable_container'], 10);
	    $container_width = intval($_POST['container_width'], 10);
	    $container_height = intval($_POST['container_height'], 10);
	    $table_margin_top = intval($_POST['table_margin_top'], 10);
	    $table_margin_bottom = intval($_POST['table_margin_bottom'], 10);
	    $show_header = intval($_POST['show_header'], 10);
	    $sticky_header = intval($_POST['sticky_header'], 10);
	    $header_font_size = intval($_POST['header_font_size'], 10);
	    $header_font_family = sanitize_text_field($_POST['header_font_family']);
	    $header_font_weight = sanitize_text_field($_POST['header_font_weight'], 10);
	    $header_font_style = sanitize_key($_POST['header_font_style']);
	    $header_position_alignment = sanitize_key($_POST['header_position_alignment']);
	    $header_background_color = sanitize_hex_color($_POST['header_background_color']);
	    $header_font_color = sanitize_hex_color($_POST['header_font_color']);
	    $header_link_color = sanitize_hex_color($_POST['header_link_color']);
	    $header_border_color = sanitize_hex_color($_POST['header_border_color']);
	    $body_font_size = intval($_POST['body_font_size'], 10);
	    $body_font_family = sanitize_text_field($_POST['body_font_family']);
	    $body_font_weight = sanitize_text_field($_POST['body_font_weight'], 10);
	    $body_font_style = sanitize_key($_POST['body_font_style']);
	    $even_rows_background_color = sanitize_hex_color($_POST['even_rows_background_color']);
	    $odd_rows_background_color = sanitize_hex_color($_POST['odd_rows_background_color']);
	    $even_rows_font_color = sanitize_hex_color($_POST['even_rows_font_color']);
	    $even_rows_link_color = sanitize_hex_color($_POST['even_rows_link_color']);
	    $odd_rows_font_color = sanitize_hex_color($_POST['odd_rows_font_color']);
	    $odd_rows_link_color = sanitize_hex_color($_POST['odd_rows_link_color']);
	    $rows_border_color = sanitize_hex_color($_POST['rows_border_color']);
	    $caption_show_caption = intval($_POST['caption_show_caption'], 10);
	    $caption_caption_side = intval($_POST['caption_caption_side'], 10);
	    $caption_text_align = intval($_POST['caption_text_align'], 10);
	    $caption_font_size = intval($_POST['caption_font_size'], 10);
	    $caption_font_family = sanitize_text_field($_POST['caption_font_family']);
	    $caption_font_weight = sanitize_text_field($_POST['header_font_weight'], 10);
	    $caption_font_style = sanitize_key($_POST['caption_font_style']);
	    $caption_font_color = sanitize_hex_color($_POST['caption_font_color']);

	    //Autocolors
	    $autocolors_priority = sanitize_key($_POST['autocolors_priority']);
        $autocolors_affected_rows_1 = sanitize_text_field($_POST['autocolors_affected_rows_1']);
        $autocolors_rows_background_color_1 = sanitize_hex_color($_POST['autocolors_rows_background_color_1']);
        $autocolors_rows_font_color_1 = sanitize_hex_color($_POST['autocolors_rows_font_color_1']);
	    $autocolors_affected_rows_2 = sanitize_text_field($_POST['autocolors_affected_rows_2']);
	    $autocolors_rows_background_color_2 = sanitize_hex_color($_POST['autocolors_rows_background_color_2']);
	    $autocolors_rows_font_color_2 = sanitize_hex_color($_POST['autocolors_rows_font_color_2']);
	    $autocolors_affected_rows_3 = sanitize_text_field($_POST['autocolors_affected_rows_3']);
	    $autocolors_rows_background_color_3 = sanitize_hex_color($_POST['autocolors_rows_background_color_3']);
	    $autocolors_rows_font_color_3 = sanitize_hex_color($_POST['autocolors_rows_font_color_3']);
	    $autocolors_affected_rows_4 = sanitize_text_field($_POST['autocolors_affected_rows_4']);
	    $autocolors_rows_background_color_4 = sanitize_hex_color($_POST['autocolors_rows_background_color_4']);
	    $autocolors_rows_font_color_4 = sanitize_hex_color($_POST['autocolors_rows_font_color_4']);
	    $autocolors_affected_rows_5 = sanitize_text_field($_POST['autocolors_affected_rows_5']);
	    $autocolors_rows_background_color_5 = sanitize_hex_color($_POST['autocolors_rows_background_color_5']);
	    $autocolors_rows_font_color_5 = sanitize_hex_color($_POST['autocolors_rows_font_color_5']);
	    $autocolors_affected_columns_1 = sanitize_text_field($_POST['autocolors_affected_columns_1']);
	    $autocolors_columns_background_color_1 = sanitize_hex_color($_POST['autocolors_columns_background_color_1']);
	    $autocolors_columns_font_color_1 = sanitize_hex_color($_POST['autocolors_columns_font_color_1']);
	    $autocolors_affected_columns_2 = sanitize_text_field($_POST['autocolors_affected_columns_2']);
	    $autocolors_columns_background_color_2 = sanitize_hex_color($_POST['autocolors_columns_background_color_2']);
	    $autocolors_columns_font_color_2 = sanitize_hex_color($_POST['autocolors_columns_font_color_2']);
	    $autocolors_affected_columns_3 = sanitize_text_field($_POST['autocolors_affected_columns_3']);
	    $autocolors_columns_background_color_3 = sanitize_hex_color($_POST['autocolors_columns_background_color_3']);
	    $autocolors_columns_font_color_3 = sanitize_hex_color($_POST['autocolors_columns_font_color_3']);
	    $autocolors_affected_columns_4 = sanitize_text_field($_POST['autocolors_affected_columns_4']);
	    $autocolors_columns_background_color_4 = sanitize_hex_color($_POST['autocolors_columns_background_color_4']);
	    $autocolors_columns_font_color_4 = sanitize_hex_color($_POST['autocolors_columns_font_color_4']);
	    $autocolors_affected_columns_5 = sanitize_text_field($_POST['autocolors_affected_columns_5']);
	    $autocolors_columns_background_color_5 = sanitize_hex_color($_POST['autocolors_columns_background_color_5']);
	    $autocolors_columns_font_color_5 = sanitize_hex_color($_POST['autocolors_columns_font_color_5']);

	    //Autoalignment
	    $autoalignment_priority = sanitize_key($_POST['autoalignment_priority']);
	    $autoalignment_affected_rows_left = sanitize_text_field($_POST['autoalignment_affected_rows_left']);
	    $autoalignment_affected_rows_center = sanitize_text_field($_POST['autoalignment_affected_rows_center']);
	    $autoalignment_affected_rows_right = sanitize_text_field($_POST['autoalignment_affected_rows_right']);
	    $autoalignment_affected_columns_left = sanitize_text_field($_POST['autoalignment_affected_columns_left']);
	    $autoalignment_affected_columns_center = sanitize_text_field($_POST['autoalignment_affected_columns_center']);
	    $autoalignment_affected_columns_right = sanitize_text_field($_POST['autoalignment_affected_columns_right']);

	    //Responsive
	    $tablet_breakpoint = intval($_POST['tablet_breakpoint'], 10);
	    $hide_tablet_list = sanitize_text_field($_POST['hide_tablet_list']);
	    $tablet_header_font_size = intval($_POST['tablet_header_font_size'], 10);
	    $tablet_body_font_size = intval($_POST['tablet_body_font_size'], 10);
	    $tablet_caption_font_size = intval($_POST['tablet_caption_font_size'], 10);
	    $tablet_hide_images = intval($_POST['tablet_hide_images'], 10);
	    $phone_breakpoint = intval($_POST['phone_breakpoint'], 10);
	    $hide_phone_list = sanitize_text_field($_POST['hide_phone_list']);
	    $phone_header_font_size = intval($_POST['phone_header_font_size'], 10);
	    $phone_body_font_size = intval($_POST['phone_body_font_size'], 10);
	    $phone_caption_font_size = intval($_POST['phone_caption_font_size'], 10);
	    $phone_hide_images = intval($_POST['phone_hide_images'], 10);

	    //Advanced
	    $enable_cell_properties = intval($_POST['enable_cell_properties'], 10);
	    $formula_average_decimals = intval($_POST['formula_average_decimals'], 10);
	    $formula_average_round = intval($_POST['formula_average_round'], 10);
	    $caption = sanitize_text_field($_POST['caption']);

        //validate data ------------------------------------------------------------------------------------------------
        $fields_with_errors_a = array();

	    //Table Data
	    if(!is_array($table_data)){
		    $fields_with_errors_a[] = 'data';
	    }

        //Basic Info
        if (strlen(trim(stripslashes($name))) < 1 or strlen(trim(stripslashes($name))) > 255) {
            $fields_with_errors_a[] = 'name';
        }
        if (strlen(trim(stripslashes($description))) < 1 or strlen(trim(stripslashes($description))) > 255) {
            $fields_with_errors_a[] = 'description';
        }
	    if (strlen(trim(stripslashes($caption))) > 2000) {
		    $fields_with_errors_a[] = 'caption';
	    }
        if (!preg_match($this->shared->digits_regex, $rows) or intval($rows, 10) < 1 or intval($rows, 10) > 10000) {
            $fields_with_errors_a[] = 'rows';
        }
        if (!preg_match($this->shared->digits_regex, $columns) or intval($columns, 10) < 1 or intval($columns, 10) > 40) {
            $fields_with_errors_a[] = 'columns';
        }

        //Sorting Options
        if (strlen(trim(stripslashes($position_label))) < 1 || strlen(trim(stripslashes($position_label))) > 255) {
            $fields_with_errors_a[] = 'position_label';
        }

        //Style Options
        if (!preg_match($this->shared->digits_regex, $table_width_value) or intval($table_width_value, 10) < 1 or intval($table_width_value, 10) > 999999) {
            $fields_with_errors_a[] = 'table_width_value';
        }
        if (!preg_match($this->shared->digits_regex, $table_minimum_width) or intval($table_minimum_width, 10) < 0 or intval($table_minimum_width, 10) > 999999) {
            $fields_with_errors_a[] = 'table_minimum_width';
        }
	    if ((!preg_match($this->shared->list_of_comma_separated_numbers, $column_width_value) and strlen(trim(stripslashes($column_width_value))) > 0) or strlen(trim(stripslashes($column_width_value))) > 2000) {
		    $fields_with_errors_a[] = 'column_width_value';
	    }
        if (!preg_match($this->shared->digits_regex, $container_width) or intval($container_width, 10) < 0 or intval($container_width, 10) > 999999) {
            $fields_with_errors_a[] = 'container_width';
        }
        if (!preg_match($this->shared->digits_regex, $container_height) or intval($container_height, 10) < 0 or intval($container_height, 10) > 999999) {
            $fields_with_errors_a[] = 'container_height';
        }
        if (!preg_match($this->shared->digits_regex, $table_margin_top) or intval($table_margin_top, 10) < 0 or intval($table_margin_top, 10) > 999999) {
            $fields_with_errors_a[] = 'table_margin_top';
        }
        if (!preg_match($this->shared->digits_regex, $table_margin_bottom) or intval($table_margin_bottom, 10) < 0 or intval($table_margin_bottom, 10) > 999999) {
            $fields_with_errors_a[] = 'table_margin_bottom';
        }
        if (!preg_match($this->shared->digits_regex, $header_font_size) or intval($header_font_size, 10) < 1 or intval($header_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'header_font_size';
        }
        if (!preg_match($this->shared->font_family_regex, stripslashes($header_font_family)) or strlen(trim(stripslashes($header_font_family))) < 1 or strlen(trim(stripslashes($header_font_family))) > 255) {
            $fields_with_errors_a[] = 'header_font_family';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $header_background_color)) {
            $fields_with_errors_a[] = 'header_background_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $header_font_color)) {
            $fields_with_errors_a[] = 'header_font_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $header_link_color)) {
            $fields_with_errors_a[] = 'header_link_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $header_border_color)) {
            $fields_with_errors_a[] = 'header_border_color';
        }
        if (!preg_match($this->shared->digits_regex, $body_font_size) or intval($body_font_size, 10) < 1 or intval($body_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'body_font_size';
        }
        if (!preg_match($this->shared->font_family_regex, stripslashes($body_font_family)) or strlen(trim(stripslashes($body_font_family))) < 1 or strlen(trim(stripslashes($body_font_family))) > 255) {
            $fields_with_errors_a[] = 'body_font_family';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $even_rows_background_color)) {
            $fields_with_errors_a[] = 'even_rows_background_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $odd_rows_background_color)) {
            $fields_with_errors_a[] = 'odd_rows_background_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $even_rows_font_color)) {
            $fields_with_errors_a[] = 'even_rows_font_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $odd_rows_font_color)) {
            $fields_with_errors_a[] = 'odd_rows_font_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $even_rows_link_color)) {
            $fields_with_errors_a[] = 'even_rows_link_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $odd_rows_link_color)) {
            $fields_with_errors_a[] = 'odd_rows_link_color';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $rows_border_color)) {
            $fields_with_errors_a[] = 'rows_border_color';
        }

	    if (!preg_match($this->shared->digits_regex, $caption_font_size) or intval($caption_font_size, 10) < 1 or intval($caption_font_size, 10) > 65535) {
		    $fields_with_errors_a[] = 'caption_font_size';
	    }
	    if (!preg_match($this->shared->font_family_regex, stripslashes($caption_font_family)) or strlen(trim(stripslashes($caption_font_family))) < 1 or strlen(trim(stripslashes($caption_font_family))) > 255) {
		    $fields_with_errors_a[] = 'caption_font_family';
	    }

	    if (!preg_match($this->shared->hex_rgb_regex, $caption_font_color)) {
		    $fields_with_errors_a[] = 'caption_font_color';
	    }

        //Autocolors Options
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_rows_1) and strlen(trim(stripslashes($autocolors_affected_rows_1))) > 0) or strlen(trim(stripslashes($autocolors_affected_rows_1))) > 2000) {
            $fields_with_errors_a[] = 'autocolors_affected_rows_1';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_background_color_1)) {
            $fields_with_errors_a[] = 'autocolors_rows_background_color_1';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_font_color_1)) {
            $fields_with_errors_a[] = 'autocolors_rows_font_color_1';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_rows_2) and strlen(trim(stripslashes($autocolors_affected_rows_2))) > 0) or strlen(trim(stripslashes($autocolors_affected_rows_2))) > 2000) {
            $fields_with_errors_a[] = 'autocolors_affected_rows_2';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_background_color_2)) {
            $fields_with_errors_a[] = 'autocolors_rows_background_color_2';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_font_color_2)) {
            $fields_with_errors_a[] = 'autocolors_rows_font_color_2';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_rows_3) and strlen(trim(stripslashes($autocolors_affected_rows_3))) > 0) or strlen(trim(stripslashes($autocolors_affected_rows_3))) > 2000) {
            $fields_with_errors_a[] = 'autocolors_affected_rows_3';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_background_color_3)) {
            $fields_with_errors_a[] = 'autocolors_rows_background_color_3';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_font_color_3)) {
            $fields_with_errors_a[] = 'autocolors_rows_font_color_3';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_rows_4) and strlen(trim(stripslashes($autocolors_affected_rows_4))) > 0) or strlen(trim(stripslashes($autocolors_affected_rows_4))) > 2000) {
            $fields_with_errors_a[] = 'autocolors_affected_rows_4';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_background_color_4)) {
            $fields_with_errors_a[] = 'autocolors_rows_background_color_4';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_font_color_4)) {
            $fields_with_errors_a[] = 'autocolors_rows_font_color_4';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_rows_5) and strlen(trim(stripslashes($autocolors_affected_rows_5))) > 0) or strlen(trim(stripslashes($autocolors_affected_rows_5))) > 2000) {
            $fields_with_errors_a[] = 'autocolors_affected_rows_5';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_background_color_5)) {
            $fields_with_errors_a[] = 'autocolors_rows_background_color_5';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_rows_font_color_5)) {
            $fields_with_errors_a[] = 'autocolors_rows_font_color_5';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_columns_1) and strlen(trim(stripslashes($autocolors_affected_columns_1))) > 0) or strlen(trim(stripslashes($autocolors_affected_columns_1))) > 110) {
            $fields_with_errors_a[] = 'autocolors_affected_columns_1';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_background_color_1)) {
            $fields_with_errors_a[] = 'autocolors_columns_background_color_1';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_font_color_1)) {
            $fields_with_errors_a[] = 'autocolors_columns_font_color_1';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_columns_2) and strlen(trim(stripslashes($autocolors_affected_columns_2))) > 0) or strlen(trim(stripslashes($autocolors_affected_columns_2))) > 110) {
            $fields_with_errors_a[] = 'autocolors_affected_columns_2';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_background_color_2)) {
            $fields_with_errors_a[] = 'autocolors_columns_background_color_2';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_font_color_2)) {
            $fields_with_errors_a[] = 'autocolors_columns_font_color_2';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_columns_3) and strlen(trim(stripslashes($autocolors_affected_columns_3))) > 0) or strlen(trim(stripslashes($autocolors_affected_columns_3))) > 110) {
            $fields_with_errors_a[] = 'autocolors_affected_columns_3';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_background_color_3)) {
            $fields_with_errors_a[] = 'autocolors_columns_background_color_3';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_font_color_3)) {
            $fields_with_errors_a[] = 'autocolors_columns_font_color_3';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_columns_4) and strlen(trim(stripslashes($autocolors_affected_columns_4))) > 0) or strlen(trim(stripslashes($autocolors_affected_columns_4))) > 110) {
            $fields_with_errors_a[] = 'autocolors_affected_columns_4';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_background_color_4)) {
            $fields_with_errors_a[] = 'autocolors_columns_background_color_4';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_font_color_4)) {
            $fields_with_errors_a[] = 'autocolors_columns_font_color_4';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autocolors_affected_columns_5) and strlen(trim(stripslashes($autocolors_affected_columns_5))) > 0) or strlen(trim(stripslashes($autocolors_affected_columns_5))) > 110) {
            $fields_with_errors_a[] = 'autocolors_affected_columns_5';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_background_color_5)) {
            $fields_with_errors_a[] = 'autocolors_columns_background_color_5';
        }
        if (!preg_match($this->shared->hex_rgb_regex, $autocolors_columns_font_color_5)) {
            $fields_with_errors_a[] = 'autocolors_columns_font_color_5';
        }

        //Autoalignment Options
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_rows_left) and strlen(trim(stripslashes($autoalignment_affected_rows_left))) > 0) or strlen(trim(stripslashes($autoalignment_affected_rows_left))) > 2000) {
            $fields_with_errors_a[] = 'autoalignment_affected_rows_left';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_rows_center) and strlen(trim(stripslashes($autoalignment_affected_rows_center))) > 0) or strlen(trim(stripslashes($autoalignment_affected_rows_center))) > 2000) {
            $fields_with_errors_a[] = 'autoalignment_affected_rows_center';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_rows_right) and strlen(trim(stripslashes($autoalignment_affected_rows_right))) > 0) or strlen(trim(stripslashes($autoalignment_affected_rows_right))) > 2000) {
            $fields_with_errors_a[] = 'autoalignment_affected_rows_right';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_columns_left) and strlen(trim(stripslashes($autoalignment_affected_columns_left))) > 0) or strlen(trim(stripslashes($autoalignment_affected_columns_left))) > 110) {
            $fields_with_errors_a[] = 'autoalignment_affected_columns_left';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_columns_center) and strlen(trim(stripslashes($autoalignment_affected_columns_center))) > 0) or strlen(trim(stripslashes($autoalignment_affected_columns_center))) > 110) {
            $fields_with_errors_a[] = 'autoalignment_affected_columns_center';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $autoalignment_affected_columns_right) and strlen(trim(stripslashes($autoalignment_affected_columns_right))) > 0) or strlen(trim(stripslashes($autoalignment_affected_columns_right))) > 110) {
            $fields_with_errors_a[] = 'autoalignment_affected_columns_right';
        }

        //Responsive Options
        if (!preg_match($this->shared->digits_regex, $tablet_breakpoint) or intval($tablet_breakpoint, 10) < 1 or intval($tablet_breakpoint, 10) > 999999) {
            $fields_with_errors_a[] = 'tablet_breakpoint';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $hide_tablet_list) and strlen(trim(stripslashes($hide_tablet_list))) > 0) or strlen(trim(stripslashes($hide_tablet_list))) > 110) {
            $fields_with_errors_a[] = 'hide_tablet_list';
        }
        if (!preg_match($this->shared->digits_regex, $tablet_header_font_size) or intval($tablet_header_font_size, 10) < 1 or intval($tablet_header_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'tablet_header_font_size';
        }
        if (!preg_match($this->shared->digits_regex, $tablet_body_font_size) or intval($tablet_body_font_size, 10) < 1 or intval($tablet_body_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'tablet_body_font_size';
        }
	    if (!preg_match($this->shared->digits_regex, $tablet_caption_font_size) or intval($tablet_caption_font_size, 10) < 1 or intval($tablet_caption_font_size, 10) > 999999) {
		    $fields_with_errors_a[] = 'tablet_caption_font_size';
	    }
        if (!preg_match($this->shared->digits_regex, $phone_breakpoint) or intval($phone_breakpoint, 10) < 1 or intval($phone_breakpoint, 10) > 999999) {
            $fields_with_errors_a[] = 'phone_breakpoint';
        }
        if ((!preg_match($this->shared->list_of_comma_separated_numbers, $hide_phone_list) and strlen(trim(stripslashes($hide_phone_list))) > 0) or strlen(trim(stripslashes($hide_phone_list))) > 110) {
            $fields_with_errors_a[] = 'hide_phone_list';
        }
        if (!preg_match($this->shared->digits_regex, $phone_header_font_size) or intval($phone_header_font_size, 10) < 1 or intval($phone_header_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'phone_header_font_size';
        }
        if (!preg_match($this->shared->digits_regex, $phone_body_font_size) or intval($phone_body_font_size, 10) < 1 or intval($phone_body_font_size, 10) > 999999) {
            $fields_with_errors_a[] = 'phone_body_font_size';
        }
	    if (!preg_match($this->shared->digits_regex, $phone_caption_font_size) or intval($phone_caption_font_size, 10) < 1 or intval($phone_caption_font_size, 10) > 999999) {
		    $fields_with_errors_a[] = 'phone_caption_font_size';
	    }

        //Advanced Options
        if (!preg_match($this->shared->digits_regex, $formula_average_decimals) or intval($formula_average_decimals, 10) < 0 or intval($formula_average_decimals, 10) > 999999) {
            $fields_with_errors_a[] = 'formula_average_decimals';
        }

        //Return an error message if the submitted data are not valid
        if (count($fields_with_errors_a) > 0) {
            echo esc_html('Failed validation on the following fields:', 'dalt') . ' ' . implode(', ', $fields_with_errors_a);
            die();
        }

        //UPDATE THE TABLE ---------------------------------------------------------------------------------------------

        //Save the table data in the 'table' db table
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $safe_sql = $wpdb->prepare("UPDATE $table_name SET

			name = %s,
			description = %s,
			caption = %s,
			`rows` = %d,
			columns = %d,
			
			/*sorting*/
            enable_sorting = %d,
            enable_manual_sorting = %d,
            show_position = %d,
            position_side = %s,
            position_label = %s,
            number_format = %d,
            order_desc_asc_1 = %d,
            order_by_1 = %d,
            order_data_type_1 = %s,
            order_date_format_1 = %s,
            order_desc_asc_2 = %d,
            order_by_2 = %d,
            order_data_type_2 = %s,
            order_date_format_2 = %s,
            order_desc_asc_3 = %d,
            order_by_3 = %d,
            order_data_type_3 = %s,
            order_date_format_3 = %s,
            order_desc_asc_4 = %d,
            order_by_4 = %d,
            order_data_type_4 = %s,
            order_date_format_4 = %s,
            order_desc_asc_5 = %d,
            order_by_5 = %d,
            order_data_type_5 = %s,
            order_date_format_5 = %s,
			
			/* style */
			table_layout = %d,
            table_width = %d,
            table_width_value = %d,
            table_minimum_width = %d,
            column_width = %d,
            column_width_value = %s,
            table_margin_top = %d,
            table_margin_bottom = %d,
            enable_container = %d,
            container_width = %d,
            container_height = %d,
            show_header = %d,
            sticky_header = %d,
            header_font_size = %d,
            header_font_family = %s,
            header_font_weight = %s,
            header_font_style = %s,
            header_background_color = %s,
            header_font_color = %s,
            header_link_color = %s,
            header_border_color = %s,
            header_position_alignment = %s,
            body_font_size = %d,
            body_font_family = %s,
            body_font_weight = %s,
            body_font_style = %s,
            even_rows_background_color = %s,
            odd_rows_background_color = %s,
            even_rows_font_color = %s,
            even_rows_link_color = %s,
            odd_rows_font_color = %s,
            odd_rows_link_color = %s,
            rows_border_color = %s,
            caption_show_caption = %d,
	        caption_caption_side = %d,
	        caption_text_align = %d,
	        caption_font_size = %d,
	        caption_font_family = %s,
	        caption_font_weight = %s,
	        caption_font_style = %s,
	        caption_font_color = %s,
            
            /* autocolors */
            autocolors_priority = %s,
            autocolors_affected_rows_1 = %s,
            autocolors_rows_background_color_1 = %s,
            autocolors_rows_font_color_1 = %s,
            autocolors_affected_rows_2 = %s,
            autocolors_rows_background_color_2 = %s,
            autocolors_rows_font_color_2 = %s,
            autocolors_affected_rows_3 = %s,
            autocolors_rows_background_color_3 = %s,
            autocolors_rows_font_color_3 = %s,
            autocolors_affected_rows_4 = %s,
            autocolors_rows_background_color_4 = %s,
            autocolors_rows_font_color_4 = %s,
            autocolors_affected_rows_5 = %s,
            autocolors_rows_background_color_5 = %s,
            autocolors_rows_font_color_5 = %s,
            autocolors_affected_columns_1 = %s,
            autocolors_columns_background_color_1 = %s,
            autocolors_columns_font_color_1 = %s,
            autocolors_affected_columns_2 = %s,
            autocolors_columns_background_color_2 = %s,
            autocolors_columns_font_color_2 = %s,
            autocolors_affected_columns_3 = %s,
            autocolors_columns_background_color_3 = %s,
            autocolors_columns_font_color_3 = %s,
            autocolors_affected_columns_4 = %s,
            autocolors_columns_background_color_4 = %s,
            autocolors_columns_font_color_4 = %s,
            autocolors_affected_columns_5 = %s,
            autocolors_columns_background_color_5 = %s,
            autocolors_columns_font_color_5 = %s,
            
            /* autoalignment */
            autoalignment_priority = %s,
            autoalignment_affected_rows_left = %s,
            autoalignment_affected_rows_center = %s,
            autoalignment_affected_rows_right = %s,
            autoalignment_affected_columns_left = %s,
            autoalignment_affected_columns_center = %s,
            autoalignment_affected_columns_right = %s,
            
            /* responsive */
            tablet_breakpoint = %d,
            hide_tablet_list = %s,
            tablet_header_font_size = %d,
            tablet_body_font_size = %d,
            tablet_caption_font_size = %d,
            tablet_hide_images = %d,
            phone_breakpoint = %d,
            hide_phone_list = %s,
            phone_header_font_size = %d,
            phone_body_font_size = %d,
            phone_caption_font_size = %d,
            phone_hide_images = %d,
            
            /* advanced */
            enable_cell_properties = %d,
            formula_average_decimals = %d,
            formula_average_round = %s,
			
            temporary = 0
            WHERE id = %d",
            $name,
            $description,
            $caption,
            $rows,
            $columns,

            //sorting
            $enable_sorting,
            $enable_manual_sorting,
            $show_position,
            $position_side,
            $position_label,
            $number_format,
            $order_desc_asc_1,
            $order_by_1,
            $order_data_type_1,
            $order_date_format_1,
            $order_desc_asc_2,
            $order_by_2,
            $order_data_type_2,
            $order_date_format_2,
            $order_desc_asc_3,
            $order_by_3,
            $order_data_type_3,
            $order_date_format_3,
            $order_desc_asc_4,
            $order_by_4,
            $order_data_type_4,
            $order_date_format_4,
            $order_desc_asc_5,
            $order_by_5,
            $order_data_type_5,
            $order_date_format_5,

            //$style
            $table_layout,
            $table_width,
            $table_width_value,
            $table_minimum_width,
            $column_width,
            $column_width_value,
            $table_margin_top,
            $table_margin_bottom,
            $enable_container,
            $container_width,
            $container_height,
            $show_header,
            $sticky_header,
            $header_font_size,
            $header_font_family,
            $header_font_weight,
            $header_font_style,
            $header_background_color,
            $header_font_color,
            $header_link_color,
            $header_border_color,
            $header_position_alignment,
            $body_font_size,
            $body_font_family,
            $body_font_weight,
            $body_font_style,
            $even_rows_background_color,
            $odd_rows_background_color,
            $even_rows_font_color,
            $even_rows_link_color,
            $odd_rows_font_color,
            $odd_rows_link_color,
            $rows_border_color,
	        $caption_show_caption,
	        $caption_caption_side,
	        $caption_text_align,
	        $caption_font_size,
	        $caption_font_family,
	        $caption_font_weight,
	        $caption_font_style,
	        $caption_font_color,

            //autocolors
            $autocolors_priority,
            $autocolors_affected_rows_1,
            $autocolors_rows_background_color_1,
            $autocolors_rows_font_color_1,
            $autocolors_affected_rows_2,
            $autocolors_rows_background_color_2,
            $autocolors_rows_font_color_2,
            $autocolors_affected_rows_3,
            $autocolors_rows_background_color_3,
            $autocolors_rows_font_color_3,
            $autocolors_affected_rows_4,
            $autocolors_rows_background_color_4,
            $autocolors_rows_font_color_4,
            $autocolors_affected_rows_5,
            $autocolors_rows_background_color_5,
            $autocolors_rows_font_color_5,
            $autocolors_affected_columns_1,
            $autocolors_columns_background_color_1,
            $autocolors_columns_font_color_1,
            $autocolors_affected_columns_2,
            $autocolors_columns_background_color_2,
            $autocolors_columns_font_color_2,
            $autocolors_affected_columns_3,
            $autocolors_columns_background_color_3,
            $autocolors_columns_font_color_3,
            $autocolors_affected_columns_4,
            $autocolors_columns_background_color_4,
            $autocolors_columns_font_color_4,
            $autocolors_affected_columns_5,
            $autocolors_columns_background_color_5,
            $autocolors_columns_font_color_5,

            //autoalignment
            $autoalignment_priority,
            $autoalignment_affected_rows_left,
            $autoalignment_affected_rows_center,
            $autoalignment_affected_rows_right,
            $autoalignment_affected_columns_left,
            $autoalignment_affected_columns_center,
            $autoalignment_affected_columns_right,

            //responsive,
            $tablet_breakpoint,
            $hide_tablet_list,
            $tablet_header_font_size,
            $tablet_body_font_size,
            $tablet_caption_font_size,
            $tablet_hide_images,
            $phone_breakpoint,
            $hide_phone_list,
            $phone_header_font_size,
            $phone_body_font_size,
            $phone_caption_font_size,
            $phone_hide_images,

            $enable_cell_properties,
            $formula_average_decimals,
            $formula_average_round,

            $table_id);

        $wpdb->query($safe_sql);

        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";

        //Delete all the data of this table
        $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d", $table_id);
        $wpdb->query($safe_sql);

        //Add the new data
        $values = array();
        $place_holders = array();
        $query = "INSERT INTO $table_name (table_id, row_index, content) VALUES ";
        foreach ($table_data as $row_index => $row_data) {

            $row_data_json = json_encode($row_data);

            array_push($values, $table_id, $row_index, $row_data_json);
            $place_holders[] = "('%d', '%d', '%s')";

        }

        $query .= implode(', ', $place_holders);
        $safe_sql = $wpdb->prepare("$query ", $values);
        $wpdb->query($safe_sql);

	    //Generate the response and terminate the script
        echo 'success';
        die();

    }

    /*
     * This method is called when in the "Tables" menu a table is edited and is used to return the data of a
     * specified table (data_content) in the json format and the indexes of the selected "order_by_*" options of the
     * table (order_by).
     *
     * The returned data in the JSON format will be used to initialize the handsontable table
     *
     * @return string A json encoded string which includes the data of the table and the indexes of the selected
     * "order_by_*" option
    */
    public function retrieve_table_data()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
        $this->shared->set_max_execution_time();
        $this->shared->set_memory_limit();

        //Sanitization
        $table_id = intval($_POST['table_id'], 10);

        //Retrieve the table data --------------------------------------------------------------------------------------

        //Retrieve the data
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
        $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
        $data_a = $wpdb->get_results($safe_sql);

        //Load the data in an array
        foreach ($data_a as $key => $data) {
            $data_content[] = json_decode($data->content);
        }

        //Retrieve the selected "Order By *" field for all the five priorities -----------------------------------------
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $safe_sql = $wpdb->prepare("SELECT order_by_1, order_by_2, order_by_3, order_by_4, order_by_5 FROM $table_name WHERE id = %d ", $table_id);
        $table_obj = $wpdb->get_row($safe_sql);

        $order_by = array();
        $order_by[1] = $table_obj->order_by_1;
        $order_by[2] = $table_obj->order_by_2;
        $order_by[3] = $table_obj->order_by_3;
        $order_by[4] = $table_obj->order_by_4;
        $order_by[5] = $table_obj->order_by_5;

        //Create an array with these two set of data (table data and list of modified cells)
        $answer = array();
        $answer['data_content'] = $data_content;
        $answer['order_by'] = $order_by;

        //Encode to json
        $answer_json = json_encode($answer);

	    //Generate the response and terminate the script
        echo $answer_json;
        die();

    }

    /*
    * Ajax handler used to add and remove rows
    *
    * This method is called when in the "Tables" menu the value of the "Rows" field changes
    */
    public function add_remove_rows()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
	    $this->shared->set_max_execution_time();
	    $this->shared->set_memory_limit();

        //Sanitization
        $table_id = intval($_POST['table_id'], 10);
        $current_number_of_rows = intval($_POST['current_number_of_rows'], 10);
        $new_number_of_rows = intval($_POST['new_number_of_rows'], 10);
        $current_number_of_columns = intval($_POST['current_number_of_columns'], 10);

        //Update the "data" db table -----------------------------------------------------------------------------------

        if ($new_number_of_rows > $current_number_of_rows) {

            /*
             * ---------------------------------------------------------------------------------------------------------
             *
             * Generate insert multirows query with placeholders:
             *
             *   INSERT INTO tbl_name
             *      (col1,col2,col3)
             *   VALUES
             *      (1,2,3),
             *      (4,5,6),
             *      (7,8,9);
             */

            //Create the first part of the insert multirows query
            $values = array();
            $place_holders = array();
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $query = "INSERT INTO $table_name (table_id, row_index, content) VALUES ";

            //Add the rows ---------------------------------------------------------------------------------------------
            $row_difference = $new_number_of_rows - $current_number_of_rows;
            for ($i = 1; $i <= $row_difference; $i++) {

                $row_index = $current_number_of_rows + $i;
                $row_data = array_fill(0, $current_number_of_columns, 0);
                $row_data_json = json_encode($row_data);

                //Prepare the values and the placeholders of the insert multirows query
                array_push($values, $table_id, $row_index, $row_data_json);
                $place_holders[] = "('%d', '%d', '%s')";

            }

            //execute insert multirows query
            $query .= implode(', ', $place_holders);
            $safe_sql = $wpdb->prepare("$query ", $values);
            $wpdb->query($safe_sql);

        } elseif ($new_number_of_rows < $current_number_of_rows) {

	        $row_difference = $current_number_of_rows - $new_number_of_rows;

            /*
             * ---------------------------------------------------------------------------------------------------------
             *
             * Generate delete multirows query with placeholders for the "data" table:
             *
             * DELETE FROM table WHERE (col1,col2) IN ((1,2),(3,4),(5,6))
             */

            //Create the first part of the delete multirows query
            global $wpdb;
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $query = "DELETE FROM $table_name WHERE (table_id, row_index) IN ";
            $values = array();
            $place_holders = array();

            //Add the values of the delete multirows query
            for ($i = 1; $i <= $row_difference; $i++) {
                array_push($values, $table_id, $new_number_of_rows + $i);
                $place_holders[] = "('%d', '%d')";
            }

            //Execute the delete multirows query
            $query .= '(' . implode(',', $place_holders) . ')';
            $safe_sql = $wpdb->prepare($query, $values);
            $wpdb->query($safe_sql);

	        /*
			 * ---------------------------------------------------------------------------------------------------------
			 *
			 * Generate delete multirows query with placeholders for the "cell" table:
			 *
			 * DELETE FROM table WHERE (col1,col2) IN ((1,2),(3,4),(5,6))
			 */

	        //Create the first part of the delete multirows query
	        global $wpdb;
	        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
	        $query = "DELETE FROM $table_name WHERE (table_id, row_index) IN ";
	        $values = array();
	        $place_holders = array();

	        //Add the values of the delete multirows query
	        for ($i = 1; $i <= $row_difference; $i++) {
		        array_push($values, $table_id, $new_number_of_rows + $i);
		        $place_holders[] = "('%d', '%d')";
	        }

	        //Execute the delete multirows query
	        $query .= '(' . implode(',', $place_holders) . ')';
	        $safe_sql = $wpdb->prepare($query, $values);
	        $wpdb->query($safe_sql);

        }

        //Update the number of rows in the "table" db table ------------------------------------------------------------
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $safe_sql = $wpdb->prepare("UPDATE $table_name SET `rows` = %d WHERE id = %d ", $new_number_of_rows, $table_id);
        $wpdb->query($safe_sql);

	    //Generate the response and terminate the script
        echo 'success';
        die();

    }

    /*
     * Ajax handler used to add and remove columns
     *
     * This method is called when in the "Tables" menu the value of the "Columns" field changes
     */
    public function add_remove_columns()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
	    $this->shared->set_max_execution_time();
	    $this->shared->set_memory_limit();

        //Sanitization
        $table_id = intval($_POST['table_id'], 10);
        $new_number_of_columns = intval($_POST['new_number_of_columns'], 10);

        //Update the "data" db table -----------------------------------------------------------------------------------

        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
        $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
        $results = $wpdb->get_results($safe_sql);

        //Parse through all the data with a foreach
        foreach ($results as $key => $result) {

            $content_a = json_decode($result->content);

            if ($new_number_of_columns > count($content_a)) {

                $content_a_count = count($content_a);
                $difference = $new_number_of_columns - $content_a_count;
                for ($i = 1; $i <= $difference; $i++) {
                    if ($result->row_index == 0) {
                        array_push($content_a, 'Label ' . ($i + $content_a_count));
                    } else {
                        array_push($content_a, 0);
                    }
                }

            } elseif ($new_number_of_columns < count($content_a)) {

                $difference = count($content_a) - $new_number_of_columns;
                for ($i = 1; $i <= $difference; $i++) {
                    array_pop($content_a);
                }

            }

            $content = json_encode($content_a);
            $table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
            $safe_sql = $wpdb->prepare("UPDATE $table_name SET content = %s WHERE id = %d ", $content, $result->id);
            $wpdb->query($safe_sql);

        }

        //If the columns are removed delete the cell properties available in the "cell" db table -----------------------

	    //Get number of columns in table
	    $current_number_of_columns = $this->shared->get_columns_field($table_id);
	    if($new_number_of_columns < $current_number_of_columns){

		    /*
			 * ---------------------------------------------------------------------------------------------------------
			 *
			 * Generate delete multirows query with placeholders for the "cell" table:
			 *
			 * DELETE FROM table WHERE (col1,col2) IN ((1,2),(3,4),(5,6))
			 */

		    //Create the first part of the delete multirows query
		    global $wpdb;
		    $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
		    $query = "DELETE FROM $table_name WHERE (table_id, column_index) IN ";
		    $values = array();
		    $place_holders = array();

		    //Add the values of the delete multirows query
		    $column_difference = $current_number_of_columns - $new_number_of_columns;
		    for ($i = 1; $i <= $column_difference; $i++) {
			    array_push($values, $table_id, $new_number_of_columns - 1 + $i);
			    $place_holders[] = "('%d', '%d')";
		    }

		    //Execute the delete multirows query
		    $query .= '(' . implode(',', $place_holders) . ')';
		    $safe_sql = $wpdb->prepare($query, $values);
		    $wpdb->query($safe_sql);

	    }

        //Update the number of columns in the "table" db table ---------------------------------------------------------
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
        $safe_sql = $wpdb->prepare("UPDATE $table_name SET columns = %d WHERE id = %d ", $new_number_of_columns, $table_id);
        $wpdb->query($safe_sql);

	    //Generate the response and terminate the script
        echo 'success';
        die();

    }

    /*
    * Ajax handler used to retrieve the cell properties of a cell as a JSON string.
    */
    public function retrieve_cell_properties()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
	    $this->shared->set_max_execution_time();
	    $this->shared->set_memory_limit();

        //Prepare data
        $table_id = intval($_POST['table_id'], 10);
        $row = intval($_POST['row'], 10);
        $column = intval($_POST['column'], 10);

        //If the data properties of the cell already exists retrieve the cell data properties
        global $wpdb;
        $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
        $safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d AND row_index = %d AND column_index = %d", $table_id, $row, $column);
        $cell_obj = $wpdb->get_row($safe_sql);

        if ($cell_obj === false or $cell_obj === null) {
            esc_html_e('no properties', 'dalt');
            die();
        }

	    //Generate the response and terminate the script
        echo json_encode($this->shared->object_stripslashes($cell_obj));
        die();

    }

	/*
	* Ajax handler used to retrieve the cell properties of multiple cells as a JSON string.
	*/
	public function retrieve_cell_properties_multiple()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Prepare data
		$table_id = intval($_POST['table_id'], 10);
		$row_start = intval($_POST['row_start'], 10);
		$column_start = intval($_POST['column_start'], 10);
		$row_end = intval($_POST['row_end'], 10);
		$column_end = intval($_POST['column_end'], 10);

		//Retrieve the cell properties of all the cells. If a cell doesn't have cell properties save the null value.
		$result = [];
		for($row_index = $row_start;$row_index <= $row_end;$row_index++){

			for($column_index = $column_start;$column_index <= $column_end;$column_index++){

				//Get the cell properties of the iterated cell
				global $wpdb;
				$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
				$safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d AND row_index = %d AND column_index = %d", $table_id, $row_index, $column_index);
				$cell_obj = $wpdb->get_row($safe_sql);

				//Save the cell properties of the iterated cell or the null value if the iterated cell doesn't have cell
				//properties.
				if ($cell_obj === false or $cell_obj === null) {
					$result[$row_index][$column_index] = false;
				}else{
					$result[$row_index][$column_index] = $this->shared->object_stripslashes($cell_obj);
				}

			}

		}

		//Generate the response and terminate the script
		echo json_encode($result);
		die();

	}

	/*
	* Ajax handler used to update the cell properties of the provided cells with the provided data.
	*/
	public function update_cell_properties_multiple()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Init vars
		$result = [];
		$errors = [];
		$row_counter = 0;
		$column_counter = null;

		//Prepare data
		$table_id = intval($_POST['table_id'], 10);
		$row_start = intval($_POST['row_start'], 10);
		$column_start = intval($_POST['column_start'], 10);
		$copied_cell_properties = $this->shared->sanitize_cell_properties_multiple(json_decode(stripslashes($_POST['copied_cell_properties']), true));

		//Get the number of rows and columns of the table
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("SELECT `rows`, `columns` FROM $table_name WHERE id = %d", $table_id);
		$table_obj = $wpdb->get_row($safe_sql);

		//Retrieve the cell properties of all the cell. If a cell doesn't have cell properties save the null value.
		foreach($copied_cell_properties as $copied_cell_properties_row){

			$column_counter = 0;

			foreach($copied_cell_properties_row as $copied_cell_properties_cell){

				//Calculate the index of the cell where the cell properties should be pasted
				$row_index = $row_start + $row_counter;
				$column_index = $column_start + $column_counter;

				//Do not proceed if the index of the cell where the cell properties should be pasted doesn't exist in
				//the table
				if($row_index > $table_obj->rows or $column_index >= $table_obj->columns){
					continue;
				}

				if($copied_cell_properties_cell === false){

					//remove the cell properties at the given index
					global $wpdb;
					$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
					$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND row_index = %d AND column_index = %d", $table_id, $row_index, $column_index);
					$result = $wpdb->query($safe_sql);

					if ($result === null) {
						$errors[] = 'Unable to delete the cell';
					}

				}else{

					//set the cell properties to the ones available in the copied cell properties status
					$cell_info = new stdClass();
					$cell_info->table_id = $table_id;
					$cell_info->row_index = $row_index;
					$cell_info->column_index = $column_index;
					$cell_info->html_content = $copied_cell_properties_cell['html_content'];
					$cell_info->text_color = $copied_cell_properties_cell['text_color'];
					$cell_info->background_color = $copied_cell_properties_cell['background_color'];
					$cell_info->font_weight = $copied_cell_properties_cell['font_weight'];
					$cell_info->font_style = $copied_cell_properties_cell['font_style'];
					$cell_info->link = $copied_cell_properties_cell['link'];
					$cell_info->link_color = $copied_cell_properties_cell['link_color'];
					$cell_info->open_link_new_tab = $copied_cell_properties_cell['open_link_new_tab'];
					$cell_info->image_left = $copied_cell_properties_cell['image_left'];
					$cell_info->image_left_link = $copied_cell_properties_cell['image_left_link'];
					$cell_info->image_left_open_link_new_tab = $copied_cell_properties_cell['image_left_open_link_new_tab'];
					$cell_info->image_right = $copied_cell_properties_cell['image_right'];
					$cell_info->image_right_link = $copied_cell_properties_cell['image_right_link'];
					$cell_info->image_right_open_link_new_tab = $copied_cell_properties_cell['image_right_open_link_new_tab'];
					$cell_info->alignment = $copied_cell_properties_cell['alignment'];
					$cell_info->formula = $copied_cell_properties_cell['formula'];
					$cell_info->formula_data = $copied_cell_properties_cell['formula_data'];
					$cell_info->row_slots = $copied_cell_properties_cell['row_slots'];
					$cell_info->column_slots = $copied_cell_properties_cell['column_slots'];

					$this->shared->save_cell($cell_info);

				}

				$column_counter++;

			}

			$row_counter++;
			
		}

		//Generate the response and terminate the script
		echo json_encode($result);
		die();

	}

    /*
     * Ajax handler used to update or reset the cell properties.
     */
    public function update_reset_cell_properties()
    {

    	//Preliminary operations
	    $this->shared->check_ajax_referer();
	    $this->shared->check_tables_menu_capability();
	    $this->shared->set_max_execution_time();
	    $this->shared->set_memory_limit();

	    //Sanitization -------------------------------------------------------------------------------------------------
	    $task = sanitize_key($_POST['task']);
	    $cell_properties = $this->shared->sanitize_cell_properties([
		    'table_id' => $_POST['table_id'],
		    'row_index' => $_POST['row_index'],
		    'column_index' => $_POST['column_index'],
		    'html_content' => $_POST['html_content'],
		    'text_color' => $_POST['text_color'],
		    'background_color' => $_POST['background_color'],
		    'font_weight' => $_POST['font_weight'],
		    'font_style' => $_POST['font_style'],
		    'link' => $_POST['link'],
		    'link_color' => $_POST['link_color'],
		    'open_link_new_tab' => $_POST['open_link_new_tab'],
		    'image_left' => $_POST['image_left'],
		    'image_left_link' => $_POST['image_left_link'],
		    'image_left_open_link_new_tab' => $_POST['image_left_open_link_new_tab'],
		    'image_right' => $_POST['image_right'],
		    'image_right_link' => $_POST['image_right_link'],
		    'image_right_open_link_new_tab' => $_POST['image_right_open_link_new_tab'],
		    'alignment' => $_POST['alignment'],
		    'formula' => $_POST['formula'],
		    'formula_data' => $_POST['formula_data'],
		    'row_slots' => $_POST['row_slots'],
		    'column_slots' => $_POST['column_slots']
	    ]);

        switch ($task) {

            //Update cell properties -----------------------------------------------------------------------------------
            case 'update-cell-properties':

                //Validation -------------------------------------------------------------------------------------------

                //Init variables
                $fields_with_errors_a = array();

                //Validate data ----------------------------------------------------------------------------------------
                if (!preg_match($this->shared->hex_rgb_regex, $cell_properties['text_color']) && strlen(trim($cell_properties['text_color'])) > 0) {
                    $fields_with_errors_a[] = 'text_color';
                }
                if (!preg_match($this->shared->hex_rgb_regex, $cell_properties['background_color']) && strlen(trim($cell_properties['background_color'])) > 0) {
                    $fields_with_errors_a[] = 'background_color';
                }
                if ((!preg_match($this->shared->url_regex, $cell_properties['link']) && strlen(trim($cell_properties['link'])) > 0) or strlen(trim($cell_properties['link'])) > 2083) {
                    $fields_with_errors_a[] = 'link';
                }
                if (!preg_match($this->shared->hex_rgb_regex, $cell_properties['link_color']) && strlen(trim($cell_properties['link_color'])) > 0) {
                    $fields_with_errors_a[] = 'link_color';
                }
                if ((!preg_match($this->shared->url_regex, $cell_properties['image_left']) && strlen(trim($cell_properties['image_left'])) > 0) or strlen(trim($cell_properties['image_left'])) > 2083) {
                    $fields_with_errors_a[] = 'image_left';
                }
                if ((!preg_match($this->shared->url_regex, $cell_properties['image_left_link']) && strlen(trim($cell_properties['image_left_link'])) > 0) or strlen(trim($cell_properties['image_left_link'])) > 2083) {
                    $fields_with_errors_a[] = 'image_left_link';
                }
                if ((!preg_match($this->shared->url_regex, $cell_properties['image_right']) && strlen(trim($cell_properties['image_right'])) > 0) or strlen(trim($cell_properties['image_right'])) > 2083) {
                    $fields_with_errors_a[] = 'image_right';
                }
                if ((!preg_match($this->shared->url_regex, $cell_properties['image_right_link']) && strlen(trim($cell_properties['image_right_link'])) > 0) or strlen(trim($cell_properties['image_right_link'])) > 2083) {
                    $fields_with_errors_a[] = 'image_right_link';
                }
                if (strlen(trim($cell_properties['html_content'])) > 65535) {
                    $fields_with_errors_a[] = 'html_content';
                }
                if ((!preg_match($this->shared->list_of_comma_separated_numbers, $cell_properties['formula_data']) and strlen(trim(stripslashes($cell_properties['formula_data']))) > 0) or strlen(trim(stripslashes($cell_properties['formula_data']))) > 110) {
                    $fields_with_errors_a[] = 'formula_data';
                }
	            if (intval($cell_properties['row_slots'], 10) < 0 and intval($cell_properties['row_slots'], 10) > 65534) {
		            $fields_with_errors_a[] = 'row_slots';
	            }
	            if (intval($cell_properties['column_slots'], 10) < 0 and intval($cell_properties['column_slots'], 10) > 1000) {
		            $fields_with_errors_a[] = 'column_slots';
	            }

                if (count($fields_with_errors_a) > 0) {
                    echo 'Failed validation on the following fields: ' . implode(', ', $fields_with_errors_a);
                    die();
                }

                //Prepare the $cell_info object that will be used by Dalt_Shared::save_cell to save the cell properties
                $cell_info = new stdClass();
                $cell_info->table_id = $cell_properties['table_id'];
                $cell_info->row_index = $cell_properties['row_index'];
                $cell_info->column_index = $cell_properties['column_index'];
                $cell_info->html_content = $cell_properties['html_content'];
                $cell_info->text_color = $cell_properties['text_color'];
                $cell_info->background_color = $cell_properties['background_color'];
                $cell_info->font_weight = $cell_properties['font_weight'];
                $cell_info->font_style = $cell_properties['font_style'];
                $cell_info->link = $cell_properties['link'];
                $cell_info->link_color = $cell_properties['link_color'];
                $cell_info->open_link_new_tab = $cell_properties['open_link_new_tab'];
                $cell_info->image_left = $cell_properties['image_left'];
                $cell_info->image_left_link = $cell_properties['image_left_link'];
                $cell_info->image_left_open_link_new_tab = $cell_properties['image_left_open_link_new_tab'];
                $cell_info->image_right = $cell_properties['image_right'];
                $cell_info->image_right_link = $cell_properties['image_right_link'];
                $cell_info->image_right_open_link_new_tab = $cell_properties['image_right_open_link_new_tab'];
                $cell_info->alignment = $cell_properties['alignment'];
                $cell_info->formula = $cell_properties['formula'];
                $cell_info->formula_data = $cell_properties['formula_data'];
                $cell_info->row_slots = $cell_properties['row_slots'];
                $cell_info->column_slots = $cell_properties['column_slots'];

                $this->shared->save_cell($cell_info);
                break;

            //Delete cell properties -----------------------------------------------------------------------------------
            case 'reset-cell-properties':

                global $wpdb;
                $table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
                $safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND row_index = %d AND column_index = %d", $cell_properties['table_id'], $cell_properties['row_index'], $cell_properties['column_index']);
                $result = $wpdb->query($safe_sql);

                if ($result === null) {
                    esc_html_e('Unable to delete the cell', 'dalt');
                    die();
                }

                break;

        }

	    //Generate the response and terminate the script
        echo 'success';
        die();

    }

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Reset Cell Properties"
	 * context menu item.
	 */
	public function reset_cell_properties()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$options = $this->shared->sanitize_cell_selection($_POST['options']);

		//Generate the cell indexes that should be removed
		$cells_to_reset = [];
		for($i=$options->start->row;$i<=$options->end->row;$i++){
			for($t=$options->start->col;$t<=$options->end->col;$t++){
				$cells_to_reset[] = [$i, $t];
			}
        }

		//Remove the cell properties
		foreach($cells_to_reset as $key => $cell_to_reset){

			//Get the cell properties from the provided cells
			global $wpdb;
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND row_index = %d AND column_index = %d", $table_id, $cell_to_reset[0], $cell_to_reset[1]);
			$wpdb->query($safe_sql);

		}

		//Encode to json
		$answer_json = json_encode('done');

		//Generate the response and terminate the script
		echo $answer_json;
		die();

	}



	/**
	 * The row index and column index of all the cells of the specificed table that has cell properties associated are
	 * echoed in json format.
	 *
	 * Handles the AJAX request called in the JavaScript method "refresh_cell_properties_highlight" and used to
	 * highlight the cells that has cell properties.
	 */
	function get_cell_properties_index(){

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);

		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
		$safe_sql = $wpdb->prepare("SELECT row_index, column_index FROM $table_name WHERE table_id = %d", $table_id);
		$cell_a = $wpdb->get_results($safe_sql);

		if ($cell_a === null) {
			echo 'no cell properties';
			die();
		}

		//Generate the response and terminate the script
		echo json_encode($cell_a);
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Insert Row Above" context
	 * menu item.
	 */
	public function insert_row_above()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$row_index = intval($_POST['row'], 10);

		//Update the "table" menu --------------------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            `rows` = `rows` + 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Count the number of subsequent rows
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE
			table_id = %d AND
	        row_index > %d",
			$table_id,
			$row_index);
		$count = $wpdb->get_var($safe_sql);

		//Update all the subsequent "row_index" in "data"
		for($i=$count+$row_index;$i>=$row_index;$i--){

			//update the row
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index + 1
            WHERE table_id = %d AND row_index = %d",
				$table_id,
				$i);
			$wpdb->query($safe_sql);

		}

		//Add the new row
		$number_of_columns = $this->shared->get_columns_field($table_id);
		$row_data = array_fill(0, $number_of_columns, "0");
		$row_data_json = json_encode($row_data);
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                            table_id = %d,
                            row_index = %d,
                            content = %s",
			$table_id,
			$row_index,
			$row_data_json
		);
		$wpdb->query($safe_sql);

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Update the row_index of the cell properties subsequent to the inserted row
		$count = $this->shared->get_rows_field($table_id);
		for($i=$count-1;$i>=$row_index;$i--){

			//Update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index + 1
            WHERE table_id = %d AND
            row_index = %d",
				$table_id,
				$i);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		echo 'success';
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Insert Row Below" context
	 * menu item.
	 */
	public function insert_row_below()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$row_index = intval($_POST['row'], 10);

		//Update the "table" menu --------------------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            `rows` = `rows` + 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Count the number of subsequent rows
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE
			table_id = %d AND
	        row_index > %d",
			$table_id,
			$row_index + 1);
		$count = $wpdb->get_var($safe_sql);

		//Update all the subsequent "row_index" in "data"
		for($i=$count+$row_index;$i>=$row_index;$i--){

			//Update the row
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index + 1
            WHERE table_id = %d AND row_index = %d",
				$table_id,
				$i + 1);
			$wpdb->query($safe_sql);

		}

		//Add the new row
		$number_of_columns = $this->shared->get_columns_field($table_id);
		$row_data = array_fill(0, $number_of_columns, "0");
		$row_data_json = json_encode($row_data);
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("INSERT INTO $table_name SET
                            table_id = %d,
                            row_index = %d,
                            content = %s",
			$table_id,
			$row_index + 1,
			$row_data_json
		);
		$wpdb->query($safe_sql);

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Update the row_index of the cell properties subsequent to the inserted row
		$count = $this->shared->get_rows_field($table_id);
		for($i=$count-1;$i>$row_index;$i--){

			//Update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index + 1
            WHERE table_id = %d AND
            row_index = %d",
				$table_id,
				$i);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		echo 'success';
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Insert Column Left"
	 * context menu item.
	 */
	public function insert_column_left()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$column_index = intval($_POST['column'], 10);

		//Update the "table" menu --------------------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            columns = columns + 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Update the "data" database table -----------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
		$results = $wpdb->get_results($safe_sql);

		//Parse through all the data with a foreach
		foreach ($results as $key => $result) {

			$content_a = json_decode($result->content);

			if($key === 0){
				array_splice($content_a, $column_index, 0, 'New Label');
			}else{
				array_splice($content_a, $column_index, 0, '0');
			}

			$content = json_encode($content_a);
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET content = %s WHERE id = %d ", $content, $result->id);
			$wpdb->query($safe_sql);

		}

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Update the column_index of the cell properties subsequent to the inserted column
		$count = $this->shared->get_columns_field($table_id);
		for($i=$count-2;$i>=$column_index;$i--){

			//update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            column_index = column_index + 1
            WHERE table_id = %d AND
            column_index = %d",
				$table_id,
				$i);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		echo 'success';
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Insert Column Right"
	 * context menu item.
	 */
	public function insert_column_right()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$column_index = intval($_POST['column'], 10);

		//Update the "table" menu --------------------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            columns = columns + 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Update the "data" database table -----------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
		$results = $wpdb->get_results($safe_sql);

		//Parse through all the data with a foreach
		foreach ($results as $key => $result) {

			$content_a = json_decode($result->content);

			if($key === 0){
				array_splice($content_a, $column_index + 1, 0, 'New Label');
			}else{
				array_splice($content_a, $column_index + 1, 0, '0');
			}

			$content = json_encode($content_a);
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET content = %s WHERE id = %d ", $content, $result->id);
			$wpdb->query($safe_sql);

		}

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Update the column_index of the cell properties subsequent to the inserted column
		$count = $this->shared->get_columns_field($table_id);
		for($i=$count-2;$i>$column_index;$i--){

			//update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            column_index = column_index + 1
            WHERE table_id = %d AND
            column_index = %d",
				$table_id,
				$i);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		esc_html_e('success', 'dalt');
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Remove Row" context menu
	 * item.
	 */
	public function remove_row()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$row_index = intval($_POST['row'], 10);

		//Update the "table" database table ----------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            `rows` = `rows` - 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Update the "data" database table -----------------------------------------------------------------------------
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND row_index = %d",
			$table_id,
			$row_index);
		$wpdb->query($safe_sql);

		/**
		 * Regenerate the "row_index" value for all the records where it's required.
		 *
		 * The procedure starts from the first index that require to be regenerated.
		 *
		 * 1 - Get the total number of records in "data"
		 * 2 - With for cycle from the first index to the last index regenerate the "row_index" field
		 */
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT COUNT(*) FROM $table_name WHERE
			table_id = %d AND
	        row_index > %d",
			$table_id,
			$row_index);
		$count = $wpdb->get_var($safe_sql);

		for($i=$row_index;$i<$count+$row_index;$i++){

			//update the row
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index -1
            WHERE table_id = %d AND row_index =%d",
				$table_id,
				$i + 1);
			$wpdb->query($safe_sql);

		}

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Delete the cell properties associated with the delete row
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
		$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND row_index = %d",
			$table_id,
			$row_index);
		$wpdb->query($safe_sql);

		//Update the row_index of the cell properties subsequent to the delete row
		for($i=$row_index;$i<$count+$row_index;$i++){

			//Update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            row_index = row_index - 1
            WHERE table_id = %d AND
            row_index = %d",
				$table_id,
				$i + 1);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		echo esc_html('success', 'dalt');
		die();

	}

	/**
	 * Handles the AJAX request called in the JavaScript method used to handle clicks on the "Remove Column" context
	 * menu item.
	 */
	public function remove_column()
	{

		//Preliminary operations
		$this->shared->check_ajax_referer();
		$this->shared->check_tables_menu_capability();
		$this->shared->set_max_execution_time();
		$this->shared->set_memory_limit();

		//Sanitization
		$table_id = intval($_POST['table_id'], 10);
		$column_index = intval($_POST['column'], 10);

		//Update the "table" database table ----------------------------------------------------------------------------
		global $wpdb;
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_table";
		$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            columns = columns - 1
            WHERE id = %d",
			$table_id);
		$wpdb->query($safe_sql);

		//Update the "data" database table -----------------------------------------------------------------------------

		//Cycle through the records and remove the specified column
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
		$safe_sql = $wpdb->prepare("SELECT * FROM $table_name WHERE table_id = %d ORDER BY row_index ASC", $table_id);
		$data_a = $wpdb->get_results($safe_sql);

		//Load the data in an array
		foreach ($data_a as $key => $data) {

			$content_a = json_decode($data->content);

			//Remove the specified row from the array
			unset($content_a[$column_index]);
			$content_a = array_values($content_a);

			//Update the record of the database table
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_data";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET content = %s WHERE id = %d",
				json_encode($content_a),
				$data->id);
			$wpdb->query($safe_sql);

		}

		//Update the "cell" menu ---------------------------------------------------------------------------------------

		//Delete the cell properties associated with the delete column
		$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
		$safe_sql = $wpdb->prepare("DELETE FROM $table_name WHERE table_id = %d AND column_index = %d",
			$table_id,
			$column_index);
		$wpdb->query($safe_sql);

		//Get the value of the "columns" field because will be used as the counter in the next step
		$count = $this->shared->get_columns_field($table_id);

		//Update the column_index of the cell properties subsequent to the delete column
		for($i=$column_index;$i< $count + $column_index -1;$i++){

			//Update the cell properties
			$table_name = $wpdb->prefix . $this->shared->get('slug') . "_cell";
			$safe_sql = $wpdb->prepare("UPDATE $table_name SET
            column_index = column_index - 1
            WHERE table_id = %d AND
            column_index = %d",
				$table_id,
				$i + 1);
			$wpdb->query($safe_sql);

		}

		//Generate the response and terminate the script
		echo esc_html('success', 'dalt');
		die();

	}

}